import React from 'react';

import {URLs} from 'constants/urls';

import {IWithClassName} from 'types/withClassName';
import {ETripsGoal} from 'utilities/metrika/types/goals/trips';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useReachGoal} from 'utilities/metrika/useReachGoal';

import * as i18nBlock from 'i18n/account-TripPage';

import ArrowBack from 'icons/16/ArrowBack';
import Link from 'components/Link/Link';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

interface INavigationProps extends IWithClassName, IWithQaAttributes {}

const BackLink: React.FC<INavigationProps> = props => {
    const {className} = props;

    const handleClick = useReachGoal(ETripsGoal.BACK_TO_TRIPS_LINK_CLICK);

    return (
        <Link
            to={URLs.accountTrips}
            className={className}
            onClick={handleClick}
            theme="black"
            {...prepareQaAttributes(props)}
        >
            <TextWithIcon
                size="m"
                iconLeft={ArrowBack}
                text={i18nBlock.myTrips()}
                spaceBetween={1}
            />
        </Link>
    );
};

export default React.memo(BackLink);
