import {FC, memo} from 'react';

import {IWithClassName} from 'types/withClassName';

import BusIcon from 'icons/24/Bus';
import Flex from 'components/Flex/Flex';

import cx from './Logo.scss';

interface ILogoProps extends IWithClassName {
    isCancelled: boolean;
}

const Logo: FC<ILogoProps> = props => {
    const {className, isCancelled} = props;

    return (
        <Flex
            className={cx('root', {root_cancelled: isCancelled}, className)}
            alignItems="center"
            justifyContent="center"
        >
            <BusIcon />
        </Flex>
    );
};

export default memo(Logo);
