import {useMemo, useState} from 'react';

import getGenericDownloadBlankUrl from 'projects/account/pages/Order/utilities/downloadBlank/getGenericDownloadBlankUrl';

import usePollDownloadBlankToken from 'projects/buses/components/OrderActions/hooks/usePollDownloadBlankToken';

export function useDownloadBlankUrl(
    orderId: string,
    initialToken?: string,
): string | undefined {
    const [downloadBlankToken, setDownloadBlankToken] = useState<
        string | undefined
    >(initialToken);

    const downloadUrl = useMemo(() => {
        if (!downloadBlankToken) {
            return;
        }

        return getGenericDownloadBlankUrl({
            orderId,
            token: downloadBlankToken,
        });
    }, [downloadBlankToken, orderId]);

    usePollDownloadBlankToken({
        initialDownloadBlankToken: initialToken,
        orderId,
        onTokenReady({downloadBlankToken: newDownloadBlankToken}) {
            setDownloadBlankToken(newDownloadBlankToken);
        },
    });

    return downloadUrl;
}
