import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useBoolean} from 'utilities/hooks/useBoolean';

import CopyPNRButtonMobile from './CopyPNRButtonMobile';

export default {
    title: 'Trips/CopyPNRButtonMobile',
    component: CopyPNRButtonMobile,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const {value, setTrue} = useBoolean(false);

    return (
        <CopyPNRButtonMobile
            copyText="Текст для копирования"
            description="Какое-то описание после копирования"
            registrationUrl="https://www.aeroflot.ru/sb/ckin/app/ru-ru"
            isCopied={value}
            onClickCopyButton={setTrue}
        />
    );
};

Simple.parameters = {
    info: {
        title: 'Тачевое копирование PNR',
    },
};
