import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useBoolean} from 'utilities/hooks/useBoolean';

import Button from 'components/Button/Button';

import mockAirlines from 'server/api/TripsApi/__mocks__/mockAirlines';

import CopyPNRModalWithCopy from './CopyPNRModalWithCopy';

export default {
    title: 'Trips/CopyPNRModalWithCopy',
    component: CopyPNRModalWithCopy,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const {value, setTrue, setFalse} = useBoolean(false);

    return (
        <>
            <Button onClick={setTrue}>Open</Button>
            <CopyPNRModalWithCopy
                pnr="VJA91"
                registrationUrl="https://www.aeroflot.ru/sb/ckin/app/ru-ru"
                airlines={[mockAirlines.aeroflot]}
                isVisible={value}
                onClose={setFalse}
            />
        </>
    );
};
