import React, {useMemo} from 'react';

import TTripForecastBlock from 'types/trips/TTripBlock/TTripForecastBlock';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import getItemsIsGrowing from 'projects/account/pages/TripPage/components/ForecastBlock/utilities/getItemsIsGrowing';
import {
    getQa,
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import ForecastItem from './components/ForecastItem/ForecastItem';
import HorizontalScroller from 'components/HorizontalScroller/HorizontalScroller';

import cx from './ForecastBlock.scss';

interface IForecastBlockProps extends IWithClassName, IWithQaAttributes {
    forecastBlock: TTripForecastBlock;
}

const ForecastBlock: React.FC<IForecastBlockProps> = props => {
    const {className, forecastBlock} = props;
    const rootQa = getQa(props);
    const deviceType = useDeviceType();

    const {items} = forecastBlock.block;

    const itemsIsGrowing = getItemsIsGrowing(deviceType, items);

    const content = useMemo(
        () => (
            <Flex inline between={1} nowrap {...prepareQaAttributes(rootQa)}>
                {items.map(item => {
                    const key = item.title;

                    return (
                        <ForecastItem
                            key={key}
                            className={cx(className, 'item', {
                                item_grow: itemsIsGrowing,
                            })}
                            item={item}
                            {...prepareQaAttributes({
                                parent: rootQa,
                                current: 'item',
                                key,
                            })}
                        />
                    );
                })}
            </Flex>
        ),
        [className, items, itemsIsGrowing, rootQa],
    );

    if (!items.length) {
        return null;
    }

    if (itemsIsGrowing) {
        return content;
    }

    return <HorizontalScroller offset={2}>{content}</HorizontalScroller>;
};

export default ForecastBlock;
