import React from 'react';

import ITripForecastItem from 'types/trips/ITripForecast/ITripForecastItem';
import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import TravelImage from 'components/TravelImage/TravelImage';
import Card from 'components/Card/Card';
import Text from 'components/Text/Text';
import Link from 'components/Link/Link';

import cx from './ForecastItem.scss';

interface IForecastItemProps extends IWithClassName, IWithQaAttributes {
    item: ITripForecastItem;
}

const ForecastItem: React.FC<IForecastItemProps> = props => {
    const {className, item} = props;

    return (
        <Card
            className={cx(className, 'root')}
            key={item.title}
            radius="m"
            x={3}
            y={2}
            {...prepareQaAttributes(props)}
        >
            <Flex inline between={2} nowrap>
                <TravelImage
                    className={cx('image')}
                    src={item.imageUrl}
                    isRenderImmediately
                    {...prepareQaAttributes({parent: props, current: 'image'})}
                />
                <Flex flexDirection="column">
                    <Text
                        size="s"
                        overflow="ellipsis"
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'title',
                        })}
                    >
                        {item.title}
                    </Text>
                    <Text
                        size="s"
                        overflow="ellipsis"
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'description',
                        })}
                    >
                        {item.description}
                    </Text>
                </Flex>
            </Flex>
            {Boolean(item.url) && (
                <Link
                    className={cx('link')}
                    target="_blank"
                    rel="noopener noreferrer"
                    url={item.url}
                    {...prepareQaAttributes({parent: props, current: 'link'})}
                />
            )}
        </Card>
    );
};

export default ForecastItem;
