import ITripForecastItem from 'types/trips/ITripForecast/ITripForecastItem';

import {IDevice} from 'reducers/common/commonReducerTypes';

/**
 * Переменная полученная опытным путем
 * строки до такой длины могут уместиться в картинке вдвоем без скрола
 */
const LONG_ITEM_LENGTH = 15;

/**
 * Элементы прогноза растягиваются на всю доступную ширину без горизонтального скрола когда их мало
 */
export default function getItemsIsGrowing(
    deviceType: IDevice,
    items: ITripForecastItem[],
): boolean {
    const forecastItemsCount = items.length;

    if (deviceType.isDesktop) {
        return forecastItemsCount < 6;
    }

    const hasLongItem = items.some(
        item =>
            item.title.length > LONG_ITEM_LENGTH ||
            item.description.length > LONG_ITEM_LENGTH,
    );

    if (hasLongItem) {
        return forecastItemsCount < 2;
    }

    return forecastItemsCount < 3;
}
