import React from 'react';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Skeleton from 'components/Skeletons/Skeleton/Skeleton';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

import cx from './Skeleton.scss';

const HotelCrossSaleSkeleton: React.FC = () => {
    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType))}>
            <TextSkeleton className={cx('title')} />

            <Skeleton className={cx('map')} />
        </div>
    );
};

export default React.memo(HotelCrossSaleSkeleton);
