import {MouseEventHandler, useCallback} from 'react';
import {Moment} from 'moment';

import {EAppActions} from 'constants/platforms/TPlatforms';

import {ETripsGoal} from 'utilities/metrika/types/goals/trips';
import IGetCrossSaleHotelsRequestParamsV3 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsRequestParamsV3';
import {TGetCrossSaleHotelsResponse} from 'server/api/HotelsCrossSaleApi/types/TGetCrossSaleHotelsResponse';

import {isV3Response} from 'utilities/crossSaleHotels/isV3Response';
import {ROBOT} from 'utilities/dateUtils/formats';
import {reachGoal} from 'utilities/metrika';

import {ContainerElement} from '@yandex-lego/components/Link/Link';

import {useCoordinator} from 'contexts/PlatformContext';

export const useCoordinatorHotelCrossSaleMapClickCallback = (
    request: IGetCrossSaleHotelsRequestParamsV3,
    data?: TGetCrossSaleHotelsResponse,
    checkinDate?: Moment | '',
    checkoutDate?: Moment | '',
): MouseEventHandler<ContainerElement> => {
    const coordinator = useCoordinator();

    return useCallback<MouseEventHandler<ContainerElement>>(
        event => {
            reachGoal(ETripsGoal.HOTELS_CROSS_SALE_CLICK);

            const crossSale =
                data && (isV3Response(data) ? data.crossSale : data);

            if (!crossSale || !checkinDate || !checkoutDate) {
                return;
            }

            const {region} = crossSale;
            const {adults, childrenAges} = request;

            const processed = coordinator.doAction(
                EAppActions.NAVIGATE_TO_SEARCH_RESULT_HOTELS_PAGE,
                {
                    region: region,
                    searchParams: {
                        checkinDate: checkinDate.format(ROBOT),
                        checkoutDate: checkoutDate.format(ROBOT),
                        adults,
                        childrenAges,
                    },
                },
            );

            if (processed) {
                event.preventDefault();
            }
        },
        [checkinDate, checkoutDate, coordinator, data, request],
    );
};
