import {FC, memo, useCallback} from 'react';

import {ETripsGoal} from 'utilities/metrika/types/goals/trips';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18n from 'i18n/account-TripPage';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import YandexMessenger, {
    IYandexMessengerRenderTriggerProps,
} from 'components/YandexMessenger/YandexMessenger';
import Button from 'components/Button/Button';
import MessageOutlineIcon from 'icons/16/MessageOutline';

import cx from './SupportAction.scss';

interface ISupportActionProps extends IWithClassName, IWithQaAttributes {}

const SupportAction: FC<ISupportActionProps> = props => {
    const {isDesktop} = useDeviceType();

    const renderTrigger = useCallback(
        ({ref, handleClick}: IYandexMessengerRenderTriggerProps) => {
            if (isDesktop) {
                return (
                    <Button
                        className={cx('button', 'trigger')}
                        innerRef={ref}
                        iconLeft={<MessageOutlineIcon />}
                        size="l"
                        onClick={handleClick}
                        {...prepareQaAttributes(props)}
                    >
                        {i18n.supportActionDescription()}
                    </Button>
                );
            }

            return (
                <Flex
                    className={cx('trigger')}
                    ref={ref}
                    alignItems="center"
                    inline
                    flexWrap="nowrap"
                    between={4}
                    onClick={handleClick}
                    {...prepareQaAttributes(props)}
                >
                    <Text className={cx('description')}>
                        {i18n.supportActionDescription()}
                    </Text>

                    <Button
                        className={cx('button')}
                        icon={<MessageOutlineIcon />}
                        size="l"
                        shape="circle"
                    />
                </Flex>
            );
        },
        [isDesktop],
    );

    return (
        <YandexMessenger
            entrypoint="tripHotelOrder"
            metrikaGoal={ETripsGoal.HOTEL_ORDER_SUPPORT_BUTTON_CLICK}
            targetPosition="bottom-right"
            renderTrigger={renderTrigger}
        />
    );
};

export default memo(SupportAction);
