import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Card, {ICardProps as ICommonCardProps} from 'components/Card/Card';

interface ICardProps
    extends IWithClassName,
        IWithQaAttributes,
        Pick<ICommonCardProps, 'x' | 'y'> {
    children: React.ReactNode;
}

const MobileCard: React.FC<ICardProps> = props => {
    const {className, x = 4, y = 3, children} = props;

    return (
        <Card className={className} x={x} y={y} {...prepareQaAttributes(props)}>
            {children}
        </Card>
    );
};

export default React.memo(MobileCard);
