import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {TTripNotificationsBlock} from 'types/trips/TTripBlock/TTripBlock';
import ETripNotificationType from 'types/trips/ITripNotifications/ETripNotificationType';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Flex from 'components/Flex/Flex';
import AviaCheckInNotification from 'projects/account/pages/TripPage/components/NotificationsBlock/components/AviaCheckInNotification/AviaCheckInNotification';
import HotelDeferredPaymentNotification from 'projects/account/pages/TripPage/components/NotificationsBlock/components/HotelDeferredPaymentNotification/HotelDeferredPaymentNotification';

interface INotificationsBlockProps extends IWithClassName {
    notificationsBlock: TTripNotificationsBlock;
}

const NotificationsBlock: React.FC<INotificationsBlockProps> = props => {
    const {className, notificationsBlock} = props;

    const deviceType = useDeviceType();

    const {notifications} = notificationsBlock.block;

    return (
        <Flex
            className={className}
            flexDirection="column"
            between={deviceType.isMobile ? 2 : 3}
        >
            {notifications.map(notification => {
                switch (notification.type) {
                    case ETripNotificationType.AVIA_CHECK_IN:
                        return (
                            <AviaCheckInNotification
                                airline={notification.airline}
                                flightTitle={notification.flightTitle}
                                flightNumber={notification.flightNumber}
                                pnr={notification.pnr}
                                checkInCounters={
                                    notification.offlineCheckIn?.checkInCounters
                                }
                                gate={notification.offlineCheckIn?.gate}
                                updatedAt={notification.updatedAt}
                                registrationUrl={notification.registrationUrl}
                            />
                        );
                    case ETripNotificationType.HOTEL_DEFERRED_PAYMENT: {
                        const {order} = notification;

                        return (
                            <HotelDeferredPaymentNotification
                                hotelTitle={order.title}
                                hotelImage={order.image}
                                hotelDisplayCheckinCheckoutDates={
                                    order.displayCheckinCheckoutDates
                                }
                                orderId={order.id}
                            />
                        );
                    }
                    case ETripNotificationType.TRIP_CREATED:
                    case ETripNotificationType.TRIP_UPDATED:
                        return null;
                    default:
                        return null;
                }
            })}
        </Flex>
    );
};

export default NotificationsBlock;
