import {Meta} from '@storybook/react/types-6-0';
import moment from 'moment';

import {TStorybookFunctionComponent} from 'storybook/types';

import mockAirlines from 'server/api/TripsApi/__mocks__/mockAirlines';

import AviaCheckInNotification from './AviaCheckInNotification';

export default {
    title: 'Trips/AviaCheckInNotification',
    component: AviaCheckInNotification,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <div style={{maxWidth: 600}}>
        <AviaCheckInNotification
            airline={mockAirlines.aeroflot}
            flightTitle="Екатеринбург — Санкт-Петербург"
            flightNumber="SU 1418"
            pnr="VJA91"
            registrationUrl="https://www.aeroflot.ru/sb/ckin/app/ru-ru"
        />
    </div>
);

export const WithOffline: TStorybookFunctionComponent = () => (
    <div style={{maxWidth: 600}}>
        <AviaCheckInNotification
            airline={mockAirlines.aeroflot}
            flightTitle="Екатеринбург — Санкт-Петербург"
            flightNumber="SU 1418"
            checkInCounters="112"
            gate="16"
            pnr="VJA91"
        />
    </div>
);

export const WithUptadetAt: TStorybookFunctionComponent = () => (
    <div style={{maxWidth: 600}}>
        <AviaCheckInNotification
            airline={mockAirlines.aeroflot}
            flightTitle="Екатеринбург — Санкт-Петербург"
            flightNumber="SU 1418"
            checkInCounters="112"
            gate="16"
            updatedAt={moment().add(-1, 'minute').format()}
            pnr="VJA91"
        />
    </div>
);
