import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IAirline} from 'types/trips/ITripAviaOrder';

import {useBoolean} from 'utilities/hooks/useBoolean';

import NotificationContainer from 'projects/account/pages/TripPage/components/NotificationsBlock/components/NotificationContainer/NotificationContainer';
import AviaCheckInNotificationHeader from './components/AviaCheckInNotificationHeader/AviaCheckInNotificationHeader';
import AviaCheckInNotificationBody from 'projects/account/pages/TripPage/components/NotificationsBlock/components/AviaCheckInNotification/components/AviaCheckInNotificationBody/AviaCheckInNotificationBody';
import AviaCheckInNotificationFooter from 'projects/account/pages/TripPage/components/NotificationsBlock/components/AviaCheckInNotification/components/AviaCheckInNotificationFooter/AviaCheckInNotificationFooter';
import CopyPNRModalWithCopy from 'projects/account/pages/TripPage/components/CopyPNRModalWithCopy/CopyPNRModalWithCopy';

interface IAviaCheckInNotificationProps extends IWithClassName {
    airline: IAirline;
    flightTitle: string;
    flightNumber: string;
    pnr: string;
    checkInCounters?: string;
    gate?: string;
    updatedAt?: string;
    registrationUrl?: string;
}

const AviaCheckInNotification: React.FC<IAviaCheckInNotificationProps> =
    props => {
        const {
            className,
            airline,
            flightTitle,
            flightNumber,
            checkInCounters,
            gate,
            updatedAt,
            registrationUrl,
            pnr,
        } = props;

        const airlines = useMemo(() => [airline], [airline]);

        const {
            setTrue: openCopyModal,
            setFalse: closeCopyModal,
            value: copyModalIsVisible,
        } = useBoolean(false);

        return (
            <>
                <NotificationContainer
                    className={className}
                    onClick={registrationUrl ? openCopyModal : undefined}
                    header={
                        <AviaCheckInNotificationHeader
                            airline={airline}
                            flightNumber={flightNumber}
                            flightTitle={flightTitle}
                        />
                    }
                    body={
                        <AviaCheckInNotificationBody
                            checkInCounters={checkInCounters}
                            gate={gate}
                        />
                    }
                    footer={
                        <AviaCheckInNotificationFooter updatedAt={updatedAt} />
                    }
                />
                {registrationUrl && (
                    <CopyPNRModalWithCopy
                        pnr={pnr}
                        registrationUrl={registrationUrl}
                        airlines={airlines}
                        isVisible={copyModalIsVisible}
                        onClose={closeCopyModal}
                    />
                )}
            </>
        );
    };

export default React.memo(AviaCheckInNotification);
