import React, {useMemo} from 'react';

import {isNotUndefined} from 'types/utilities';
import ENotificationBodyTheme from 'projects/account/pages/TripPage/components/NotificationsBlock/components/NotificationBody/types/ENotificationBodyTheme';

import * as i18n from 'i18n/trips-notifications';

import Flex from 'components/Flex/Flex';
import Intersperse from 'components/Intersperse/Intersperse';
import Separator from 'components/Separator/Separator';
import Text from 'components/Text/Text';
import NotificationBody from 'projects/account/pages/TripPage/components/NotificationsBlock/components/NotificationBody/NotificationBody';

interface IAviaCheckInNotificationBodyProps {
    checkInCounters?: string;
    gate?: string;
}

const AviaCheckInNotificationBody: React.FC<IAviaCheckInNotificationBodyProps> =
    props => {
        const {checkInCounters, gate} = props;

        const infos = useMemo(() => {
            return [
                checkInCounters
                    ? {
                          title: i18n.aviaCheckInCounters(),
                          value: checkInCounters,
                          key: 'checkInCounters',
                      }
                    : undefined,
                gate
                    ? {title: i18n.aviaGateTitle(), value: gate, key: 'gate'}
                    : undefined,
            ].filter(isNotUndefined);
        }, [checkInCounters, gate]);

        return (
            <Intersperse separator={<Separator margin={3} />}>
                <NotificationBody theme={ENotificationBodyTheme.SUCCESS}>
                    {i18n.aviaCheckUpTitle()}
                </NotificationBody>
                {Boolean(infos.length) && (
                    <Flex inline between={5}>
                        {infos.map(info => (
                            <Flex key={info.key} flexDirection="column">
                                <Text>{info.title}</Text>
                                <Text size="xl">{info.value}</Text>
                            </Flex>
                        ))}
                    </Flex>
                )}
            </Intersperse>
        );
    };

export default AviaCheckInNotificationBody;
