import React, {useCallback, useEffect, useState} from 'react';
import moment from 'moment';

import {MINUTE} from 'utilities/dateUtils/constants';

import {IWithClassName} from 'types/withClassName';

import {formatDurationTime} from 'utilities/dateUtils/formatDurationTime/formatDurationTime';
import {getNow} from 'utilities/dateUtils';

import * as i18n from 'i18n/trips-notifications';

import Text from 'components/Text/Text';

interface IAviaCheckInNotificationFooterProps extends IWithClassName {
    updatedAt?: string;
}

const AviaCheckInNotificationFooter: React.FC<IAviaCheckInNotificationFooterProps> =
    props => {
        const {className, updatedAt} = props;

        const calculateTimeAgo = useCallback(() => {
            const seconds = moment(getNow()).diff(updatedAt, 'seconds');

            return formatDurationTime(seconds, {
                linguistic: 'accusativeCase',
                precision: 'minute',
            });
        }, [updatedAt]);

        const [timeAgo, setTimeAgo] = useState(calculateTimeAgo());

        useEffect(() => {
            const id = setInterval(() => {
                setTimeAgo(calculateTimeAgo());
            }, MINUTE);

            return () => {
                clearInterval(id);
            };
        }, [calculateTimeAgo]);

        if (!timeAgo) {
            return null;
        }

        return (
            <Text className={className} size="s" color="secondary">
                {i18n.deprecationWarning({
                    timeAgo,
                })}
            </Text>
        );
    };

export default AviaCheckInNotificationFooter;
