import React from 'react';

import {IAirline} from 'types/trips/ITripAviaOrder';
import {IWithClassName} from 'types/withClassName';

import AirlinesLogo from 'projects/account/pages/TripPage/components/AirlinesLogo/AirlinesLogo';
import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

interface IAviaCheckInNotificationHeaderProps extends IWithClassName {
    airline: IAirline;
    flightTitle: string;
    flightNumber: string;
}

const AviaCheckInNotificationHeader: React.FC<IAviaCheckInNotificationHeaderProps> =
    props => {
        const {className, airline, flightTitle, flightNumber} = props;

        return (
            <Flex className={className} inline alignItems="center" between={3}>
                <AirlinesLogo airlines={[airline]} size="x-small" />
                <Flex flexDirection="column">
                    <Text size="m" weight="bold" overflow="ellipsis">
                        {flightTitle}
                    </Text>
                    <Text size="m">
                        {airline.title}, {flightNumber}
                    </Text>
                </Flex>
            </Flex>
        );
    };

export default React.memo(AviaCheckInNotificationHeader);
