import React from 'react';

import {IWithClassName} from 'types/withClassName';
import ENotificationBodyTheme from 'projects/account/pages/TripPage/components/NotificationsBlock/components/NotificationBody/types/ENotificationBodyTheme';

import {accountURLs} from 'projects/account/utilities/urls';

import * as i18n from 'i18n/trips-notifications';

import HotelDeferredPaymentNotificationHeader from 'projects/account/pages/TripPage/components/NotificationsBlock/components/HotelDeferredPaymentNotification/components/HotelDeferredPaymentNotificationHeader/HotelDeferredPaymentNotificationHeader';
import NotificationBody from 'projects/account/pages/TripPage/components/NotificationsBlock/components/NotificationBody/NotificationBody';

import NotificationContainer from '../NotificationContainer/NotificationContainer';

interface IHotelDeferredPaymentNotificationProps extends IWithClassName {
    hotelTitle: string;
    hotelDisplayCheckinCheckoutDates: string;
    hotelImage: string | undefined;
    orderId: string;
}

const HotelDeferredPaymentNotification: React.FC<IHotelDeferredPaymentNotificationProps> =
    props => {
        const {
            className,
            hotelTitle,
            hotelImage,
            hotelDisplayCheckinCheckoutDates,
            orderId,
        } = props;

        return (
            <NotificationContainer
                className={className}
                header={
                    <HotelDeferredPaymentNotificationHeader
                        hotelTitle={hotelTitle}
                        hotelImage={hotelImage}
                        hotelDisplayCheckinCheckoutDates={
                            hotelDisplayCheckinCheckoutDates
                        }
                    />
                }
                body={
                    <NotificationBody theme={ENotificationBodyTheme.ALERT}>
                        {i18n.hotelDeferredPaymentTitle()}
                    </NotificationBody>
                }
                linkProps={{
                    to: accountURLs.getOrderUrl(orderId),
                }}
            />
        );
    };

export default HotelDeferredPaymentNotification;
