import React from 'react';

import {IWithClassName} from 'types/withClassName';
import ETripImageType from 'projects/trips/components/TripImage/types/ETripImageType';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import TripImage from 'projects/trips/components/TripImage/TripImage';

interface IHotelDeferredPaymentNotificationHeaderProps extends IWithClassName {
    hotelTitle: string;
    hotelDisplayCheckinCheckoutDates: string;
    hotelImage: string | undefined;
}

const HotelDeferredPaymentNotificationHeader: React.FC<IHotelDeferredPaymentNotificationHeaderProps> =
    props => {
        const {
            className,
            hotelTitle,
            hotelDisplayCheckinCheckoutDates,
            hotelImage,
        } = props;

        return (
            <Flex className={className} inline alignItems="center" between={3}>
                <TripImage
                    src={hotelImage}
                    type={ETripImageType.X_SMALL_SQUARE}
                />
                <Flex flexDirection="column">
                    <Text size="m" weight="bold" overflow="ellipsis">
                        {hotelTitle}
                    </Text>
                    <Text size="m">{hotelDisplayCheckinCheckoutDates}</Text>
                </Flex>
            </Flex>
        );
    };

export default HotelDeferredPaymentNotificationHeader;
