import React from 'react';

import {IWithClassName} from 'types/withClassName';
import ENotificationBodyTheme from 'projects/account/pages/TripPage/components/NotificationsBlock/components/NotificationBody/types/ENotificationBodyTheme';

import ArrowRightIcon from 'icons/16/ArrowRight';
import Flex from 'components/Flex/Flex';

import cx from './NotificationBody.scss';

interface INotificationBodyProps extends IWithClassName {
    theme?: ENotificationBodyTheme;
}

const NotificationBody: React.FC<INotificationBodyProps> = props => {
    const {className, theme = ENotificationBodyTheme.SUCCESS, children} = props;

    return (
        <Flex
            className={cx(className, 'root', {
                root_success: theme === ENotificationBodyTheme.SUCCESS,
                root_alert: theme === ENotificationBodyTheme.ALERT,
            })}
            inline
            justifyContent="space-between"
            alignItems="center"
        >
            <div>
                <div className={cx('circle')} />
                {children}
            </div>
            <ArrowRightIcon />
        </Flex>
    );
};

export default NotificationBody;
