import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Card from 'components/Card/Card';
import Link, {TLinkProps} from 'components/Link/Link';

import cx from './NotificationContainer.scss';

interface INotificationContainerProps
    extends IWithClassName,
        IWithQaAttributes {
    header: React.ReactNode;
    body: React.ReactNode;
    footer?: React.ReactNode;
    linkProps?: TLinkProps;
    onClick?(): void;
}

const NotificationContainer: React.FC<INotificationContainerProps> = props => {
    const {className, header, body, footer, linkProps, onClick} = props;

    return (
        <Card
            className={cx(className, 'root', {root_pointer: onClick})}
            inset={4}
            onClick={onClick}
            {...prepareQaAttributes(props)}
        >
            <div>{header}</div>
            <Card className={cx('body')} radius="s" x={3} y={4}>
                {body}
            </Card>
            {footer && <div className={cx('footer')}>{footer}</div>}
            {linkProps && (
                <Link
                    {...linkProps}
                    className={cx(linkProps.className, 'link')}
                />
            )}
        </Card>
    );
};

export default NotificationContainer;
