import {FC, memo} from 'react';

import TTripRestrictionsBlock from 'types/trips/TTripBlock/TTripRestrictionsBlock';
import {IWithClassName} from 'types/withClassName';

import useFetchCountryRestrictions from 'components/CountryRestrictions/hooks/useFetchCountryRestrictions';
import CountryRestrictions from 'components/CountryRestrictions/CountryRestrictions';

interface IRestrictionsBlockProps extends IWithClassName {
    restrictionsBlock: TTripRestrictionsBlock;
}

const RestrictionsBlock: FC<IRestrictionsBlockProps> = props => {
    const {
        className,
        restrictionsBlock: {
            block: {fromCountryTitle, toCountryTitle, request: requestParams},
        },
    } = props;

    const countryRestrictions = useFetchCountryRestrictions(requestParams);

    return (
        <CountryRestrictions
            className={className}
            countryRestrictions={countryRestrictions}
            fromCountryTitle={fromCountryTitle}
            toCountryTitle={toCountryTitle}
        />
    );
};

export default memo(RestrictionsBlock);
