import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import Skeleton from 'components/Skeletons/Skeleton/Skeleton';
import Separator from 'components/Separator/Separator';
import Flex from 'components/Flex/Flex';

import cx from './Skeleton.scss';

interface ITripSkeletonProps extends IWithClassName {}

const TripSkeleton: React.FC<ITripSkeletonProps> = props => {
    const {className} = props;

    const deviceType = useDeviceType();

    const {isDesktop, isMobile} = deviceType;
    const titleNode = <TextSkeleton className={cx('title')} size="xxl" />;

    return (
        <Flex
            className={cx('root', deviceMods('root', deviceType), className)}
            flexDirection="column"
        >
            {isMobile && titleNode}

            <Skeleton className={cx('image')} />

            <div className={cx('orderBlock')}>
                <TextSkeleton className={cx('blockTitle')} size="xl" />

                <div className={cx('order')}>
                    <Flex
                        between={4}
                        alignItems="center"
                        flexWrap="nowrap"
                        inline
                    >
                        <Skeleton className={cx('orderImage')} />

                        <Flex
                            className={cx('orderInfo')}
                            flexDirection="column"
                        >
                            <TextSkeleton
                                className={cx('orderTitle')}
                                size={isDesktop ? 'l' : 'm'}
                            />

                            <TextSkeleton className={cx('orderDate')} />
                        </Flex>
                    </Flex>

                    <Separator margin={isDesktop ? 4 : 3} />

                    <Flex className={cx('actions')} alignItems="center">
                        <TextSkeleton className={cx('actionTitle')} />
                    </Flex>
                </div>
            </div>
        </Flex>
    );
};

export default React.memo(TripSkeleton);
