import React from 'react';

import {IWithClassName} from 'types/withClassName';

import Flex from 'components/Flex/Flex';
import TrainIcon from 'icons/24/Train';

import cx from './Logo.scss';

interface ILogoProps extends IWithClassName {
    isCancelled: boolean;
}

const Logo: React.FC<ILogoProps> = props => {
    const {className, isCancelled} = props;

    return (
        <Flex
            className={cx('root', {root_cancelled: isCancelled}, className)}
            alignItems="center"
            justifyContent="center"
        >
            <TrainIcon />
        </Flex>
    );
};

export default React.memo(Logo);
