import {EHttpStatusCodes} from 'types/httpStatusCodes';

import * as i18n from 'i18n/account-TripPage';

export enum EActionType {
    LOGIN = 'LOGIN',
    RE_LOGIN = 'RE_LOGIN',
    VIEW_TRIPS = 'VIEW_TRIPS',
}

interface IErrorRenderInfo {
    description: string;
    actionType: EActionType;
}

export function getErrorRenderInfo(
    status: number | null,
    isAuth: boolean,
): IErrorRenderInfo | null {
    if (status === EHttpStatusCodes.NotFound) {
        if (isAuth) {
            return {
                description: i18n.errorNotFoundAuthDescription(),
                actionType: EActionType.VIEW_TRIPS,
            };
        }

        return {
            description: i18n.errorNotFoundNotAuthDescription(),
            actionType: EActionType.LOGIN,
        };
    }

    if (status === EHttpStatusCodes.Forbidden) {
        if (isAuth) {
            return {
                description: i18n.errorForbiddenAuthDescription(),
                actionType: EActionType.RE_LOGIN,
            };
        }

        return {
            description: i18n.errorForbiddenNotAuthDescription(),
            actionType: EActionType.LOGIN,
        };
    }

    return null;
}
