import TTripBlock, {
    TTripAviaOrderBlock,
    TTripHotelOrderBlock,
    TTripTrainOrderBlock,
    TTripBusOrderBlock,
    TTripHotelCrossSaleBlock,
    TTripActivitiesBlock,
    TTripRestrictionsBlock,
    TTripNotificationsBlock,
    TTripForecastBlock,
} from 'types/trips/TTripBlock/TTripBlock';
import ETripBlockType from 'types/trips/ETripBlockType';
import TTripAsyncBlock from 'types/trips/TTripBlock/TTripAsyncBlock';

export function isAviaOrderBlock(
    block: TTripBlock,
): block is TTripAviaOrderBlock {
    return block.type === ETripBlockType.AVIA_ORDER;
}

export function isHotelOrderBlock(
    block: TTripBlock,
): block is TTripHotelOrderBlock {
    return block.type === ETripBlockType.HOTEL_ORDER;
}

export function isTrainOrderBlock(
    block: TTripBlock,
): block is TTripTrainOrderBlock {
    return block.type === ETripBlockType.TRAIN_ORDER;
}

export function isBusOrderBlock(
    block: TTripBlock,
): block is TTripBusOrderBlock {
    return block.type === ETripBlockType.BUS_ORDER;
}

export function isHotelCrossSaleBlock(
    block: TTripBlock,
): block is TTripHotelCrossSaleBlock {
    return block.type === ETripBlockType.HOTEL_CROSS_SALE;
}

export function isActivitiesBlock(
    block: TTripBlock,
): block is TTripActivitiesBlock {
    return block.type === ETripBlockType.ACTIVITIES;
}

export function isNotificationsBlock(
    block: TTripBlock,
): block is TTripNotificationsBlock {
    return block.type === ETripBlockType.NOTIFICATIONS;
}

export function isRestrictionsBlock(
    block: TTripBlock,
): block is TTripRestrictionsBlock {
    return block.type === ETripBlockType.RESTRICTIONS;
}

export function isForecastBlock(
    block: TTripBlock,
): block is TTripForecastBlock {
    return block.type === ETripBlockType.FORECAST;
}

export function isAsyncBlock(block: TTripBlock): block is TTripAsyncBlock {
    return 'isLoaded' in block;
}
