import ETripBlockType from 'types/trips/ETripBlockType';
import ITrip from 'types/trips/ITrip';

import {isAsyncBlock} from 'projects/account/pages/TripPage/utilities/blocks';

export default function getNotLoadedBlockTypes(trip: ITrip): ETripBlockType[] {
    return trip.blocks
        .filter(isAsyncBlock)
        .filter(block => !block.isLoaded)
        .map(block => block.type);
}
