import ITrip from 'types/trips/ITrip';
import TTripAsyncBlock from 'types/trips/TTripBlock/TTripAsyncBlock';

export default function patchBlocksInTrip(
    trip: ITrip,
    asyncBlocks: TTripAsyncBlock[],
): ITrip {
    return {
        ...trip,
        blocks: trip.blocks.map(block => {
            const asyncBlock = asyncBlocks.find(b => b.type === block.type);

            if (asyncBlock) {
                return asyncBlock;
            }

            return block;
        }),
    };
}
