import {FC, memo} from 'react';

import TTripListItem from 'types/trips/TTripListItem/TTripListItem';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import DesktopActiveTrips from 'projects/account/pages/TripsPage/components/ActiveTrips/components/DesktopActiveTrips/DesktopActiveTrips';
import MobileActiveTrips from 'projects/account/pages/TripsPage/components/ActiveTrips/components/MobileActiveTrips/MobileActiveTrips';

export interface IActiveTripsProps extends IWithQaAttributes {
    trips: TTripListItem[];
}

const ActiveTrips: FC<IActiveTripsProps> = props => {
    const deviceType = useDeviceType();

    if (deviceType.isMobile) {
        return <MobileActiveTrips {...props} />;
    }

    return <DesktopActiveTrips {...props} />;
};

export default memo(ActiveTrips);
