import {FC, memo} from 'react';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {getTripListItemKey} from 'projects/trips/utilities/getTripListItemKey';

import Flex from 'components/Flex/Flex';
import ActiveTripItem from 'projects/account/pages/TripsPage/components/ActiveTrips/components/MobileActiveTrips/components/ActiveTripItem/ActiveTripItem';
import {IActiveTripsProps} from 'projects/account/pages/TripsPage/components/ActiveTrips/ActiveTrips';
import EmptyTripsPlaceholder from 'projects/account/pages/TripsPage/components/EmptyTripsPlaceholder/EmptyTripsPlaceholder';

interface IMobileActiveTripsProps extends IActiveTripsProps {}

const MobileActiveTrips: FC<IMobileActiveTripsProps> = props => {
    const {trips} = props;

    if (!trips.length) {
        return (
            <EmptyTripsPlaceholder
                {...prepareQaAttributes({
                    parent: props,
                    current: 'emptyTripsPlaceholder',
                })}
            />
        );
    }

    return (
        <Flex flexDirection="column" between={8}>
            {trips.map(trip => {
                const key = getTripListItemKey(trip);

                return (
                    <ActiveTripItem
                        key={key}
                        trip={trip}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'activeTrip',
                            key,
                        })}
                    />
                );
            })}
        </Flex>
    );
};

export default memo(MobileActiveTrips);
