import React, {useCallback} from 'react';

import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';
import {EAppActions} from 'constants/platforms/TPlatforms';

import {IWithClassName} from 'types/withClassName';
import {ETripsGoal} from 'utilities/metrika/types/goals/trips';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18n from 'i18n/account-TripsPage';

import NoTripsTransparentS from 'icons/illustrations/NoTripsTransparent/NoTripsTransparentS';
import ButtonLink from 'components/ButtonLink/ButtonLink';
import Flex from 'components/Flex/Flex';
import Heading from 'components/Heading/Heading';

import {useCoordinator} from 'contexts/PlatformContext';

import cx from './EmptyTripsPlaceholder.scss';

interface IEmptyTripsPlaceholderProps
    extends IWithClassName,
        IWithQaAttributes {}

const EmptyTripsPlaceholder: React.FC<IEmptyTripsPlaceholderProps> = props => {
    const {className} = props;

    const deviceType = useDeviceType();

    const coordinator = useCoordinator();

    const handleClick: React.MouseEventHandler = useCallback(
        e => {
            const processed = coordinator.doAction(
                EAppActions.NAVIGATE_TO_INDEX_PAGE,
            );

            coordinator.doAction(EAppActions.REPORT_METRICS_EVENT, {
                name: ETripsGoal.NO_ORDERS_BUTTON_CLICK,
            });

            if (processed) {
                e.preventDefault();
            }
        },
        [coordinator],
    );

    return (
        <Flex
            className={cx(className, 'root', deviceMods('root', deviceType))}
            flexDirection="column"
            alignItems="center"
            {...prepareQaAttributes(props)}
        >
            <NoTripsTransparentS
                className={cx('illustration')}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'illustration',
                })}
            />

            <Heading
                className={cx('noOrdersDescription')}
                level={2}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'noOrdersDescription',
                })}
            >
                {i18n.noOrdersDescription()}
            </Heading>

            <ButtonLink
                className={cx('noOrdersButton')}
                size="l"
                width="max"
                theme="primary"
                to={URLs[EProjectName.INDEX]}
                onClick={handleClick}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'noOrdersButton',
                })}
            >
                {i18n.noOrdersButton()}
            </ButtonLink>
        </Flex>
    );
};

export default EmptyTripsPlaceholder;
