import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18n from 'i18n/account-TripsPage';

import Heading from 'components/Heading/Heading';
import Spinner from 'components/Spinner/Spinner';

import cx from './LoadingTripsPage.scss';

interface ILoadingTripsPageProps extends IWithQaAttributes {}

const LoadingTripsPage: React.FC<ILoadingTripsPageProps> = props => {
    const deviceType = useDeviceType();

    return (
        <div
            className={cx('root', deviceMods('root', deviceType))}
            {...prepareQaAttributes(props)}
        >
            {deviceType.isMobile && <Heading level={1}>{i18n.title()}</Heading>}
            <div className={cx('spinnerContainer')}>
                <Spinner size="l" />
            </div>
        </div>
    );
};

export default LoadingTripsPage;
