import React, {useCallback, useEffect} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {ETripsGoal} from 'utilities/metrika/types/goals/trips';

import {fetchMoreTripsList} from 'reducers/trips/tripsList/thunk';

import moreTripsButtonSelector from './selectors/moreTripsButtonSelector';

import getMorePastTripsCount from 'projects/account/pages/TripsPage/components/MoreTripsButton/utilities/getMorePastTripsCount';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {reachGoal} from 'utilities/metrika';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18n from 'i18n/account-TripsPage';

import Button from 'components/Button/Button';

interface IMoreTripsButtonProps extends IWithClassName, IWithQaAttributes {}

const MoreTripsButton: React.FC<IMoreTripsButtonProps> = props => {
    const {className} = props;

    const deviceType = useDeviceType();

    const dispatch = useDispatch();
    const {isLoading, continuationToken} = useSelector(moreTripsButtonSelector);

    const handleClick = useCallback(() => {
        if (!continuationToken) {
            return;
        }

        dispatch(
            fetchMoreTripsList({
                continuationToken,
                limit: getMorePastTripsCount(),
            }),
        );

        reachGoal(ETripsGoal.GET_MORE_PAST_TRIPS_BUTTON_CLICK);
    }, [dispatch, continuationToken]);

    useEffect(() => {
        if (!continuationToken) {
            return;
        }

        reachGoal(ETripsGoal.GET_MORE_PAST_TRIPS_BUTTON_SHOW);
    }, [continuationToken]);

    if (!continuationToken) {
        return null;
    }

    return (
        <Button
            className={className}
            size="l"
            width={deviceType.isMobile ? 'max' : undefined}
            onClick={handleClick}
            disabled={isLoading}
            {...prepareQaAttributes(props)}
        >
            {i18n.moreTripsButton()}
        </Button>
    );
};

export default MoreTripsButton;
