import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {isAuthUser} from 'utilities/userInfo/isAuthUser';
import {useUserInfo} from 'utilities/hooks/useUserInfo';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18n from 'i18n/account-TripsPage';

import OrderSearchForm from 'projects/account/components/OrdesSearchForm/OrdersSearchForm';
import Heading from 'components/Heading/Heading';
import Flex from 'components/Flex/Flex';
import DesktopSupportPhone from 'projects/trips/components/DesktopSupportPhone/DesktopSupportPhone';

import cx from './NoAuthTripsPage.scss';

interface INoAuthTripsPageProps extends IWithQaAttributes {}

const NoAuthTripsPage: React.FC<INoAuthTripsPageProps> = props => {
    const deviceType = useDeviceType();
    const userInfo = useUserInfo();
    const isAuth = isAuthUser(userInfo);

    return (
        <Flex
            className={cx('root', deviceMods('root', deviceType))}
            alignItems="flex-start"
            justifyContent="space-between"
            {...prepareQaAttributes(props)}
        >
            <OrderSearchForm
                className={cx('form')}
                title={
                    <Heading
                        className={cx('title')}
                        level={1}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'searchFormTitle',
                        })}
                    >
                        {i18n.orderSearchTitle()}
                    </Heading>
                }
                deviceType={deviceType}
                authorizePath={userInfo.authorizePath}
                isAuth={isAuth}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'orderSearchForm',
                })}
            />

            {deviceType.isDesktop && (
                <DesktopSupportPhone
                    className={cx('phone')}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'supportPhone',
                    })}
                />
            )}
        </Flex>
    );
};

export default NoAuthTripsPage;
