import React from 'react';

import TTripListItem from 'types/trips/TTripListItem/TTripListItem';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {getTripListItemKey} from 'projects/trips/utilities/getTripListItemKey';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import PastTripItem from 'projects/account/pages/TripsPage/components/PastTripItem/PastTripItem';

import cx from './PastTrips.scss';

interface IPastTripsProps extends IWithClassName, IWithQaAttributes {
    trips: TTripListItem[];
}

const PastTrips: React.FC<IPastTripsProps> = props => {
    const {className, trips} = props;
    const deviceType = useDeviceType();

    return (
        <div
            className={cx(className, 'root', deviceMods('root', deviceType))}
            {...prepareQaAttributes(props)}
        >
            {trips.map(trip => {
                const key = getTripListItemKey(trip);

                return (
                    <PastTripItem
                        key={key}
                        className={cx('trip')}
                        trip={trip}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'pastTrip',
                            key,
                        })}
                    />
                );
            })}
        </div>
    );
};

export default PastTrips;
