import {ComponentType, FC} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IIconProps} from 'icons/types/icon';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Link, {TLinkProps} from 'components/Link/Link';
import Text from 'components/Text/Text';

import cx from './SearchLink.scss';

interface ISearchLinkProps
    extends IWithClassName,
        IWithQaAttributes,
        Pick<TLinkProps, 'onClick'> {
    to: string;
    icon: ComponentType<IIconProps>;
}

const SearchLink: FC<ISearchLinkProps> = props => {
    const {className, to, icon: Icon, onClick, children} = props;

    const deviceType = useDeviceType();

    return (
        <Link
            className={cx('root', deviceMods('root', deviceType), className)}
            to={{pathname: to, state: {scrollTop: null}}}
            theme="none"
            onClick={onClick}
            {...prepareQaAttributes(props)}
        >
            <Icon />

            <Text className={cx('caption')} color="current">
                {children}
            </Text>
        </Link>
    );
};

export default SearchLink;
