import React, {useCallback} from 'react';

import {EAppActions} from 'constants/platforms/TPlatforms';
import {URLs} from 'constants/urls';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {isAuthUser} from 'utilities/userInfo/isAuthUser';
import {useUserInfo} from 'utilities/hooks/useUserInfo';
import {deviceMods} from 'utilities/stylesUtils';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import goBack from 'utilities/browser/goBack';

import * as i18n from 'i18n/account-TripsPage';

import OrderSearchForm from 'projects/account/components/OrdesSearchForm/OrdersSearchForm';
import AccountModal from 'projects/account/components/AccountModal/AccountModal';

import {useCoordinator} from 'contexts/PlatformContext';

import cx from './SearchOrder.scss';

const ROOT_QA = 'searchOrderModal';

interface ISearchOrderProps {}

const SearchOrder: React.FC<ISearchOrderProps> = () => {
    const deviceType = useDeviceType();
    const userInfo = useUserInfo();
    const isAuth = isAuthUser(userInfo);
    const coordinator = useCoordinator();

    const handleClose = useCallback(() => {
        const processed = coordinator.doAction(
            EAppActions.NAVIGATE_TO_TRIPS_PAGE,
        );

        if (processed) {
            return;
        }

        goBack(URLs.accountTrips);
    }, [coordinator]);

    return (
        <AccountModal
            isVisible
            onClose={handleClose}
            backButtonTitle={i18n.searchOrderBackLink()}
            contentClassName={cx('content', deviceMods('content', deviceType))}
            allowFullScreen
            isOwnUrlForModal
            {...prepareQaAttributes(ROOT_QA)}
        >
            <OrderSearchForm
                deviceType={deviceType}
                authorizePath={userInfo.authorizePath}
                isAuth={isAuth}
                {...prepareQaAttributes({
                    parent: ROOT_QA,
                    current: 'orderSearchForm',
                })}
            />
        </AccountModal>
    );
};

export default SearchOrder;
