import {FC, useCallback} from 'react';

import {URLs} from 'constants/urls';
import {EAppActions} from 'constants/platforms/TPlatforms';

import {IWithClassName} from 'types/withClassName';
import {ETripsGoal} from 'utilities/metrika/types/goals/trips';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18n from 'i18n/account-TripsPage';

import SearchLink from 'projects/account/pages/TripsPage/components/SearchLink/SearchLink';
import SearchIcon16 from 'icons/16/Search';
import SearchIcon24 from 'icons/24/Search';

import {useCoordinator} from 'contexts/PlatformContext';

interface ISearchOrderLinkProps extends IWithClassName, IWithQaAttributes {}

const SearchOrderLink: FC<ISearchOrderLinkProps> = props => {
    const {className} = props;

    const {isMobile} = useDeviceType();
    const coordinator = useCoordinator();

    const handleOnLinkClick = useCallback(() => {
        coordinator.doAction(EAppActions.REPORT_METRICS_EVENT, {
            name: ETripsGoal.SEARCH_ORDER_LINK_CLICK,
        });
    }, [coordinator]);

    return (
        <SearchLink
            className={className}
            to={URLs.accountTripsSearch}
            icon={isMobile ? SearchIcon16 : SearchIcon24}
            onClick={handleOnLinkClick}
            {...prepareQaAttributes(props)}
        >
            {i18n.searchOrdersLink2()}
        </SearchLink>
    );
};

export default SearchOrderLink;
