import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';

import {EPassportMode, getPassportUrl} from 'utilities/url/getPassportUrl';
import {useUserInfo} from 'utilities/hooks/useUserInfo';

import * as i18nBlock from 'i18n/account-ToursOrdersSearch';

import Heading from 'components/Heading/Heading';
import Text from 'components/Text/Text';
import ButtonLink from 'components/ButtonLink/ButtonLink';
import Flex from 'components/Flex/Flex';
import LoginS from 'icons/illustrations/Login/LoginS';

import cx from './AuthInfo.scss';

interface IAuthInfoProps extends IWithClassName, IWithDeviceType {}

const AuthInfo: React.FC<IAuthInfoProps> = ({className, deviceType}) => {
    const {isMobile} = deviceType;

    const userInfo = useUserInfo();

    return (
        <Flex
            className={cx(className, 'root')}
            flexDirection="column"
            alignItems="center"
        >
            <LoginS className={cx('icon')} />
            <Heading className={cx('header')} level="2">
                {i18nBlock.authTitle()}
            </Heading>
            <Text className={cx('text')}>{i18nBlock.authText()}</Text>

            <ButtonLink
                className={cx('buttonLink')}
                url={getPassportUrl({
                    mode: EPassportMode.AUTH,
                    passportHost: userInfo.passportPath,
                    retpath: __CLIENT__ ? window.location.href : '',
                })}
                size={isMobile ? 'l' : 'm'}
                theme="primary"
            >
                {i18nBlock.login()}
            </ButtonLink>
        </Flex>
    );
};

export default AuthInfo;
