import React from 'react';

import {YANDEX_PLUS_URL} from 'constants/urls/plus';

import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/account-ToursOrdersSearch';

import Heading from 'components/Heading/Heading';
import Text from 'components/Text/Text';
import ButtonLink from 'components/ButtonLink/ButtonLink';
import Flex from 'components/Flex/Flex';
import Plus5M from 'icons/illustrations/Plus5/Plus5M';

import cx from './PlusInfo.scss';

interface IPlusInfoProps extends IWithClassName, IWithDeviceType {}

const PlusInfo: React.FC<IPlusInfoProps> = ({deviceType, className}) => {
    const {isMobile} = deviceType;

    return (
        <Flex
            className={cx('root', className)}
            flexDirection="column"
            alignItems="center"
        >
            <Plus5M className={cx('icon')} />
            <Heading className={cx('header')} level="2">
                {i18nBlock.plusTitle()}
            </Heading>
            <Text className={cx('text')}>{i18nBlock.plusText()}</Text>

            <ButtonLink
                tabIndex={-1}
                className={cx('buttonLink')}
                url={YANDEX_PLUS_URL}
                target="_blank"
                size={isMobile ? 'l' : 'm'}
                theme="plus"
            >
                {i18nBlock.plusButton()}
            </ButtonLink>
        </Flex>
    );
};

export default PlusInfo;
