import {FC} from 'react';

import {URLs} from 'constants/urls';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18n from 'i18n/account-TripsPage';

import SearchLink from 'projects/account/pages/TripsPage/components/SearchLink/SearchLink';
import ToursIcon16 from 'icons/16/Tours';
import ToursIcon24 from 'icons/24/Tours';

interface ISearchToursOrderLinkLinkProps
    extends IWithClassName,
        IWithQaAttributes {}

const SearchToursOrderLink: FC<ISearchToursOrderLinkLinkProps> = props => {
    const {className} = props;

    const {isMobile} = useDeviceType();

    return (
        <SearchLink
            className={className}
            to={URLs.accountToursSearch}
            icon={isMobile ? ToursIcon16 : ToursIcon24}
            {...prepareQaAttributes(props)}
        >
            {i18n.searchToursOrdersLink2()}
        </SearchLink>
    );
};

export default SearchToursOrderLink;
