import {IOrderAuthorization} from 'reducers/common/checkOrderAuthorization/reducer';

export function checkOrderAccess(
    orderId: string,
    orderAuthorization: IOrderAuthorization,
): boolean {
    const {checkAuthorization, createAuthorization} = orderAuthorization;

    return Boolean(
        (checkAuthorization.isSuccess || createAuthorization.isSuccess) &&
            checkAuthorization.orderIds &&
            checkAuthorization.orderIds.id === orderId,
    );
}
