import TTripListItem from 'types/trips/TTripListItem/TTripListItem';
import {ETripListItemType} from 'types/trips/ETripListItemType';

import {getOrderUrl} from 'projects/account/utilities/urls/getOrderUrl';
import {getTripUrl} from 'projects/account/utilities/urls/getTripUrl';

export function getTripOrOrderUrl(tripListItem: TTripListItem): string {
    return tripListItem.type === ETripListItemType.ORDER
        ? getOrderUrl(tripListItem.orderId)
        : getTripUrl(tripListItem.id);
}
