import {URLs} from 'constants/urls';

import {internalUrl} from 'utilities/url';

import {getOrderUrl} from './getOrderUrl';

const getAviaOrderUrl = (id: string): string =>
    internalUrl(`${URLs.avia}/orders/${id}`);
const getHotelsOrderUrl = (id: string): string =>
    internalUrl(URLs.hotelsBookSuccess, {orderId: id});
const getPassengerUrl = (userId: string): string =>
    internalUrl(`${URLs.account}/passengers/${userId}`);

export const accountURLs = {
    getOrderUrl,
    getAviaOrderUrl,
    getHotelsOrderUrl,
    getPassengerUrl,
};
