import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {TLinkTarget} from 'types/common/TLinkTarget';

import cx from './AmpButtonLink.scss';

interface IAmpButtonLinkProps extends IWithClassName {
    url: string;
    theme: 'primary' | 'secondary';
    target?: TLinkTarget;
}

const AmpButtonLink: FunctionComponent<IAmpButtonLinkProps> = ({
    className,
    theme,
    target,
    url,
    children,
}) => {
    return (
        <a
            className={cx('root', `root_theme_${theme}`, className)}
            href={url}
            target={target}
            rel={target === '_blank' ? 'noopener noreferrer' : undefined}
        >
            {children}
        </a>
    );
};

export default AmpButtonLink;
