import {ReactNode, FunctionComponent} from 'react';
import Helmet from 'react-helmet';

import {IWithClassName} from 'types/withClassName';

interface IAmpCarouselProps extends IWithClassName {
    children: ReactNode;
    height: number;
}

const AmpCarousel: FunctionComponent<IAmpCarouselProps> = ({
    className,
    children,
    height,
}) => {
    return (
        <>
            <Helmet>
                <script
                    async
                    custom-element="amp-carousel"
                    src="https://cdn.ampproject.org/v0/amp-carousel-0.1.js"
                />
            </Helmet>
            <amp-carousel class={className} height={height}>
                {children}
            </amp-carousel>
        </>
    );
};

export default AmpCarousel;
