import {FunctionComponent} from 'react';

import Box from 'components/Box/Box';
import AmpCopyright from './components/AmpCopyright/AmpCopyright';
import AmpSocialLinks from './components/AmpSocialLinks/AmpSocialLinks';
import AmpFooterLinks from './components/AmpFooterLinks/AmpFooterLinks';

import cx from './AmpFooter.scss';

interface IAmpFooterProps {}

const AmpFooter: FunctionComponent<IAmpFooterProps> = () => {
    return (
        <div className={cx('root')}>
            <Box className={cx('content')} between="5">
                <AmpFooterLinks />

                <AmpSocialLinks />

                <AmpCopyright className={cx('copyright')} />
            </Box>
        </div>
    );
};

export default AmpFooter;
