import {FunctionComponent} from 'react';

import {YANDEX_ROOT_PATH} from 'constants/common';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/common-footer';

import Copyright from 'components/Copyright/Copyright';
import AmpLink from 'projects/amp/components/AmpLink/AmpLink';

import cx from './AmpCopyright.scss';

interface IAmpCopyrightProps extends IWithClassName {}

const AmpCopyright: FunctionComponent<IAmpCopyrightProps> = ({className}) => {
    return (
        <Copyright className={className} start={2015}>
            <AmpLink
                className={cx('copyrightLink')}
                url={YANDEX_ROOT_PATH}
                target="_blank"
            >
                {i18nBlock.companyDashName()}
            </AmpLink>
        </Copyright>
    );
};

export default AmpCopyright;
