import {FunctionComponent} from 'react';

import getMenuItems from 'components/Footer/constants/footerMenuItems';
import {TLD_PLACEHOLDER} from 'components/Footer/constants/footerLinks';

import {EFooterProject} from 'components/Footer/types';

import {useTld} from 'utilities/hooks/useTld';

import Box from 'components/Box/Box';
import AmpLink from 'projects/amp/components/AmpLink/AmpLink';

import cx from './AmpFooterLinks.scss';

const AmpFooterLinks: FunctionComponent = () => {
    const tld = useTld();

    const links = getMenuItems({
        footerType: EFooterProject.HOTELS,
    });

    return (
        <Box inline between="5">
            {links.map(({link, name}) => (
                <AmpLink
                    key={link}
                    url={link.replace(TLD_PLACEHOLDER, tld)}
                    className={cx('link')}
                    theme="black"
                    target="_blank"
                >
                    {name}
                </AmpLink>
            ))}
        </Box>
    );
};

export default AmpFooterLinks;
